/*
 * Decompiled with CFR 0.152.
 */
package com.patentpia.sso;

import com.google.gson.Gson;
import com.patentpia.sso.model.JsonErrorModel;
import com.patentpia.sso.model.JsonMessageModel;
import com.patentpia.sso.model.JsonUserDataModel;
import com.patentpia.sso.model.JsonUserModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.net.ssl.HttpsURLConnection;

public class Client {
    private String key;
    private String site;
    private String pid;
    private String userIp;
    private String userAgent;
    private String language;
    private String method = "POST";
    private String protocol = "https";
    private String url = "sso.patentpia.com";
    private String program;
    private String parameter;
    private String encode = "UTF-8";
    private int status;
    private String message;
    private JsonUserDataModel user;
    private boolean isRenew;

    public static void main(String[] args) throws IOException {
        Client client = new Client();
        client.setKey("5BPQMcRI2EHF5467bQvW5T3w8qWV3kAcz8HrVLJ03CcqC7ipa0FwYSTCsHYe4HEO");
        client.setSite("patentpia");
        client.setPid("jBuvBEz.DmkjiCOTNNCcKJGkcVkyPsUhMqpdhHBC.brIu.CAYYYrLFqCns");
        JsonUserDataModel user = client.getUser();
        if (client.getStatus() == 200) {
            System.out.println(client.getStatus());
            System.out.println(user.getUserid());
            System.out.println(user.getGroup().get(0).getGroup_seq());
            System.out.println(user.getGroup().get(0).getExpiredate());
            System.out.println(user.getGroup().get(0).getPoint());
        } else {
            System.out.println(client.getStatus());
            System.out.println(client.getMessage());
        }
        if (client.renewToken()) {
            System.out.println(client.getStatus());
        } else {
            System.out.println(client.getStatus());
            System.out.println(client.getMessage());
        }
    }

    public JsonUserDataModel getUser() throws IOException {
        this.program = "/user";
        this.resetParameter();
        this.setParameter("key", this.key);
        this.setParameter("site", this.site);
        this.setParameter("pid", this.pid);
        this.setParameter("userIp", this.userIp);
        this.setParameter("userAgent", this.userAgent);
        if (this.protocol.equals("http")) {
            this.http(1);
        }
        if (this.protocol.equals("https")) {
            this.https(1);
        }
        return this.user;
    }

    public boolean renewToken() throws IOException {
        this.program = "/user/token/renew";
        this.resetParameter();
        this.setParameter("key", this.key);
        this.setParameter("site", this.site);
        this.setParameter("pid", this.pid);
        this.setParameter("userIp", this.userIp);
        this.setParameter("userAgent", this.userAgent);
        this.isRenew = false;
        if (this.protocol.equals("http")) {
            this.http(2);
        }
        if (this.protocol.equals("https")) {
            this.https(2);
        }
        return this.isRenew;
    }

    private void http(int parsingType) throws IOException {
        URL targetUrl = new URL(this.getUrl());
        HttpURLConnection con = (HttpURLConnection)targetUrl.openConnection();
        con.setRequestMethod(this.method);
        con.setDoInput(true);
        con.setDoOutput(true);
        con.connect();
        OutputStream os = con.getOutputStream();
        os.write(this.parameter.getBytes(this.encode));
        os.flush();
        os.close();
        this.status = 0;
        this.status = con.getResponseCode();
        if (this.status == 200) {
            InputStream is = con.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, this.encode);
            BufferedReader br = new BufferedReader(isr);
            this.parsing(br, parsingType);
            br.close();
        } else {
            InputStream is = con.getErrorStream();
            InputStreamReader isr = new InputStreamReader(is, this.encode);
            BufferedReader br = new BufferedReader(isr);
            this.parsingError(br, parsingType);
            br.close();
        }
        con.disconnect();
    }

    private void https(int parsingType) throws IOException {
        URL targetUrl = new URL(this.getUrl());
        HttpsURLConnection con = (HttpsURLConnection)targetUrl.openConnection();
        con.setRequestMethod(this.method);
        con.setDoInput(true);
        con.setDoOutput(true);
        con.connect();
        OutputStream os = con.getOutputStream();
        os.write(this.parameter.getBytes("UTF-8"));
        os.flush();
        os.close();
        this.status = 0;
        this.status = con.getResponseCode();
        if (this.status == 200) {
            InputStream is = con.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, this.encode);
            BufferedReader br = new BufferedReader(isr);
            this.parsing(br, parsingType);
            br.close();
        } else {
            InputStream is = con.getErrorStream();
            InputStreamReader isr = new InputStreamReader(is, this.encode);
            BufferedReader br = new BufferedReader(isr);
            this.parsingError(br, parsingType);
            br.close();
        }
        con.disconnect();
    }

    private void parsing(BufferedReader br, int parsingType) throws IOException {
        Object json;
        Gson gson;
        if (parsingType == 0) {
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        if (parsingType == 1) {
            gson = new Gson();
            json = (JsonUserModel)gson.fromJson((Reader)br, JsonUserModel.class);
            this.user = ((JsonUserModel)json).getUser();
        }
        if (parsingType == 2 && ((JsonMessageModel)(json = (JsonMessageModel)(gson = new Gson()).fromJson((Reader)br, JsonMessageModel.class))).getMessage().equals("success")) {
            this.isRenew = true;
        }
    }

    private void parsingError(BufferedReader br, int parsingType) throws IOException {
        if (parsingType == 0) {
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        } else {
            Gson gson = new Gson();
            JsonErrorModel json = (JsonErrorModel)gson.fromJson((Reader)br, JsonErrorModel.class);
            this.message = json.getError().getMessage();
        }
    }

    private String getUrl() {
        String u = String.valueOf(this.protocol) + "://";
        u = String.valueOf(u) + this.url;
        if (this.language != null) {
            u = String.valueOf(u) + "/" + this.language;
        }
        u = String.valueOf(u) + this.program;
        return u;
    }

    public void setParameter(String key, String value) {
        if (this.parameter.length() > 0) {
            this.parameter = String.valueOf(this.parameter) + "&";
        }
        try {
            this.parameter = String.valueOf(this.parameter) + key + "=" + URLEncoder.encode(value, this.encode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetParameter() {
        this.parameter = "";
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }
}

